/*******************************************************************
*
*  DESCRIPTION: Atomic Model applicationProcess
*
*  AUTHOR: Srivastav Janapalli
*
*  EMAIL: sjana086@uottawa.ca
*
*  DATE: 30/10/2016
*
*******************************************************************/

#include "applicationProcess.h"
#include "message.h"
#include "mainsimu.h"
#include <time.h>    // time()

/** public functions **/

/*******************************************************************
* Function Name: Buffer
* Description:
********************************************************************/
ApplicationProcess::ApplicationProcess( const string &name )
: Atomic( name )
, applicationProcessIN( addInputPort( "applicationProcessIN" ) )
, applicationProcessStatus( addOutputPort( "applicationProcessStatus" ) )
, applicationProcessOUT( addOutputPort( "applicationProcessOUT" ) )
, applicationProcessTime( 0, 0, 5, 0 )
{

}

/*******************************************************************
* Function Name: initFunction
* Description:
* Precondition:
********************************************************************/
Model &ApplicationProcess::initFunction()
{
	this-> passivate();

	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &ApplicationProcess::externalFunction( const ExternalMessage &msg )
{
	//std::cout << "msg.port() value: " << &msg ;
	//std::cout << " this->state() value: " << this->state() << "\n";
	if( msg.port() == applicationProcessIN && this->state() == passive)
	{
		tempNum = static_cast < int >( msg.value() );
		//std::cout << "	current value: " << tempNum << "\n";

		srand((unsigned)time(0));
		// 70 % probability that students choose to submit their appication
		bool choice = ((rand() % 100) < 70) ? true : false;
		//std::cout << "	choice output: " << choice;

		if(choice == 1)
		{
			checkNum = 1;
		}
		else {
			checkNum = 0;
		}
		//cout << "	checkNum value: " << checkNum << "\n";
		holdIn (active, applicationProcessTime);
		//cout << "	Holdingin" << "\n";
	}

	return *this;
}


/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &ApplicationProcess::internalFunction( const InternalMessage & )
{

	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &ApplicationProcess::outputFunction( const InternalMessage &msg )
{	if (checkNum == 1)
	{	sendOutput( msg.time(), applicationProcessOUT, tempNum ) ;
		sendOutput ( msg.time(), applicationProcessStatus, tempNum );
	}
	else
		sendOutput ( msg.time(), applicationProcessStatus, tempNum );
	return *this ;

}
